# Card

### Description

Represents the payment details of a card to be used for payments. These details are determined by the `card_nonce` generated by `SqPaymentForm`.

## Properties
Name | Getter | Setter | Type | Description | Notes
------------ | ------------- | ------------- | ------------- | ------------- | -------------
**id** | getId() | setId($value) | **string** | Unique ID for this card. Generated by Square. | [optional] 
**card_brand** | getCardBrand() | setCardBrand($value) | **string** | The card&#39;s brand. See [CardBrand](#type-cardbrand) for possible values | [optional] 
**last_4** | getLast4() | setLast4($value) | **string** | The last 4 digits of the card number. | [optional] 
**exp_month** | getExpMonth() | setExpMonth($value) | **int** | The expiration month of the associated card as an integer between 1 and 12. | [optional] 
**exp_year** | getExpYear() | setExpYear($value) | **int** | The four-digit year of the card&#39;s expiration date. | [optional] 
**cardholder_name** | getCardholderName() | setCardholderName($value) | **string** | The name of the cardholder. | [optional] 
**billing_address** | getBillingAddress() | setBillingAddress($value) | [**\SquareConnect\Model\Address**](Address.md) | The billing address for this card. | [optional] 
**fingerprint** | getFingerprint() | setFingerprint($value) | **string** | __Not currently set.__ Intended as a Square-assigned identifier, based  on the card number, to identify the card across multiple locations within a single application. | [optional] 
**card_type** | getCardType() | setCardType($value) | **string** | The type of the card. The Card object includes this field only in response to Payments API calls. See [CardType](#type-cardtype) for possible values | [optional] [beta]
**prepaid_type** | getPrepaidType() | setPrepaidType($value) | **string** | Indicates whether the Card is prepaid or not. The Card object includes this field only in response to Payments API calls. See [CardPrepaidType](#type-cardprepaidtype) for possible values | [optional] [beta]
**bin** | getBin() | setBin($value) | **string** | The first six digits of the card number, known as the Bank Identification Number (BIN). Only the Payments API returns this field. | [optional] 

Note: All properties are protected and only accessed via getters and setters.

[[Back to Model list]](../../README.md#documentation-for-models) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to README]](../../README.md)

