# InventoryTransfer

### Description

Represents the transfer of a quantity of product inventory at a particular time from one location to another.

## Properties
Name | Getter | Setter | Type | Description | Notes
------------ | ------------- | ------------- | ------------- | ------------- | -------------
**id** | getId() | setId($value) | **string** | A unique ID generated by Square for the &#x60;InventoryTransfer&#x60;. | [optional] 
**reference_id** | getReferenceId() | setReferenceId($value) | **string** | An optional ID provided by the application to tie the &#x60;InventoryTransfer&#x60; to an external system. | [optional] 
**state** | getState() | setState($value) | **string** | The &#x60;InventoryState&#x60; for the quantity of items being transfered. See [InventoryState](#type-inventorystate) for possible values | [optional] 
**from_location_id** | getFromLocationId() | setFromLocationId($value) | **string** | The Square ID of the &#x60;Location&#x60; where the related quantity of items were tracked before the transfer. | [optional] 
**to_location_id** | getToLocationId() | setToLocationId($value) | **string** | The Square ID of the &#x60;Location&#x60; where the related quantity of items were tracked after the transfer. | [optional] 
**catalog_object_id** | getCatalogObjectId() | setCatalogObjectId($value) | **string** | The Square generated ID of the &#x60;CatalogObject&#x60; being tracked. | [optional] 
**catalog_object_type** | getCatalogObjectType() | setCatalogObjectType($value) | **string** | The &#x60;CatalogObjectType&#x60; of the &#x60;CatalogObject&#x60; being tracked.Tracking is only supported for the &#x60;ITEM_VARIATION&#x60; type. | [optional] 
**quantity** | getQuantity() | setQuantity($value) | **string** | The number of items affected by the transfer as a decimal string. Can support up to 5 digits after the decimal point.  _Important_: The Point of Sale app and Dashboard do not currently support decimal quantities. If a Point of Sale app or Dashboard attempts to read a decimal quantity on inventory counts or adjustments, the quantity will be rounded down to the nearest integer. For example, &#x60;2.5&#x60; will become &#x60;2&#x60;, and &#x60;-2.5&#x60; will become &#x60;-3&#x60;. Read [Decimal Quantities (BETA)](https://developer.squareup.com/docs/docs/inventory-api/what-it-does#decimal-quantities-beta) for more information. | [optional] [beta]
**occurred_at** | getOccurredAt() | setOccurredAt($value) | **string** | A client-generated timestamp in RFC 3339 format that indicates when the transfer took place. For write actions, the &#x60;occurred_at&#x60; timestamp cannot be older than 24 hours or in the future relative to the time of the request. | [optional] 
**created_at** | getCreatedAt() | setCreatedAt($value) | **string** | A read-only timestamp in RFC 3339 format that indicates when Square received the transfer request. | [optional] 
**source** | getSource() | setSource($value) | [**\SquareConnect\Model\SourceApplication**](SourceApplication.md) | Read-only information about the application that initiated the inventory transfer. | [optional] 
**employee_id** | getEmployeeId() | setEmployeeId($value) | **string** | The Square ID of the &#x60;Employee&#x60; responsible for the inventory transfer. | [optional] 

Note: All properties are protected and only accessed via getters and setters.

[[Back to Model list]](../../README.md#documentation-for-models) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to README]](../../README.md)

