<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * CashDrawerShiftSummary Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class CashDrawerShiftSummary implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'id' => 'string',
        'state' => 'string',
        'opened_at' => 'string',
        'ended_at' => 'string',
        'closed_at' => 'string',
        'description' => 'string',
        'opened_cash_money' => '\SquareConnect\Model\Money',
        'expected_cash_money' => '\SquareConnect\Model\Money',
        'closed_cash_money' => '\SquareConnect\Model\Money'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'id' => 'id',
        'state' => 'state',
        'opened_at' => 'opened_at',
        'ended_at' => 'ended_at',
        'closed_at' => 'closed_at',
        'description' => 'description',
        'opened_cash_money' => 'opened_cash_money',
        'expected_cash_money' => 'expected_cash_money',
        'closed_cash_money' => 'closed_cash_money'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'id' => 'setId',
        'state' => 'setState',
        'opened_at' => 'setOpenedAt',
        'ended_at' => 'setEndedAt',
        'closed_at' => 'setClosedAt',
        'description' => 'setDescription',
        'opened_cash_money' => 'setOpenedCashMoney',
        'expected_cash_money' => 'setExpectedCashMoney',
        'closed_cash_money' => 'setClosedCashMoney'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'id' => 'getId',
        'state' => 'getState',
        'opened_at' => 'getOpenedAt',
        'ended_at' => 'getEndedAt',
        'closed_at' => 'getClosedAt',
        'description' => 'getDescription',
        'opened_cash_money' => 'getOpenedCashMoney',
        'expected_cash_money' => 'getExpectedCashMoney',
        'closed_cash_money' => 'getClosedCashMoney'
    );
  
    /**
      * $id The shift unique ID.
      * @var string
      */
    protected $id;
    /**
      * $state The shift current state. See [CashDrawerShiftState](#type-cashdrawershiftstate) for possible values
      * @var string
      */
    protected $state;
    /**
      * $opened_at The shift start time in ISO 8601 format.
      * @var string
      */
    protected $opened_at;
    /**
      * $ended_at The shift end time in ISO 8601 format.
      * @var string
      */
    protected $ended_at;
    /**
      * $closed_at The shift close time in ISO 8601 format.
      * @var string
      */
    protected $closed_at;
    /**
      * $description An employee free-text description of a cash drawer shift.
      * @var string
      */
    protected $description;
    /**
      * $opened_cash_money The amount of money in the cash drawer at the start of the shift. This must be a positive amount.
      * @var \SquareConnect\Model\Money
      */
    protected $opened_cash_money;
    /**
      * $expected_cash_money The amount of money that should be in the cash drawer at the end of the shift, based on the cash drawer events on the shift. The amount is correct if all shift employees accurately recorded their cash drawer shift events. Unrecorded events and events with the wrong amount result in an incorrect expected_cash_money amount that can be negative.
      * @var \SquareConnect\Model\Money
      */
    protected $expected_cash_money;
    /**
      * $closed_cash_money The amount of money found in the cash drawer at the end of the shift by an auditing employee. The amount must be greater than or equal to zero.
      * @var \SquareConnect\Model\Money
      */
    protected $closed_cash_money;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["id"])) {
              $this->id = $data["id"];
            } else {
              $this->id = null;
            }
            if (isset($data["state"])) {
              $this->state = $data["state"];
            } else {
              $this->state = null;
            }
            if (isset($data["opened_at"])) {
              $this->opened_at = $data["opened_at"];
            } else {
              $this->opened_at = null;
            }
            if (isset($data["ended_at"])) {
              $this->ended_at = $data["ended_at"];
            } else {
              $this->ended_at = null;
            }
            if (isset($data["closed_at"])) {
              $this->closed_at = $data["closed_at"];
            } else {
              $this->closed_at = null;
            }
            if (isset($data["description"])) {
              $this->description = $data["description"];
            } else {
              $this->description = null;
            }
            if (isset($data["opened_cash_money"])) {
              $this->opened_cash_money = $data["opened_cash_money"];
            } else {
              $this->opened_cash_money = null;
            }
            if (isset($data["expected_cash_money"])) {
              $this->expected_cash_money = $data["expected_cash_money"];
            } else {
              $this->expected_cash_money = null;
            }
            if (isset($data["closed_cash_money"])) {
              $this->closed_cash_money = $data["closed_cash_money"];
            } else {
              $this->closed_cash_money = null;
            }
        }
    }
    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
  
    /**
     * Sets id
     * @param string $id The shift unique ID.
     * @return $this
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }
  
    /**
     * Sets state
     * @param string $state The shift current state. See [CashDrawerShiftState](#type-cashdrawershiftstate) for possible values
     * @return $this
     */
    public function setState($state)
    {
        $this->state = $state;
        return $this;
    }
    /**
     * Gets opened_at
     * @return string
     */
    public function getOpenedAt()
    {
        return $this->opened_at;
    }
  
    /**
     * Sets opened_at
     * @param string $opened_at The shift start time in ISO 8601 format.
     * @return $this
     */
    public function setOpenedAt($opened_at)
    {
        $this->opened_at = $opened_at;
        return $this;
    }
    /**
     * Gets ended_at
     * @return string
     */
    public function getEndedAt()
    {
        return $this->ended_at;
    }
  
    /**
     * Sets ended_at
     * @param string $ended_at The shift end time in ISO 8601 format.
     * @return $this
     */
    public function setEndedAt($ended_at)
    {
        $this->ended_at = $ended_at;
        return $this;
    }
    /**
     * Gets closed_at
     * @return string
     */
    public function getClosedAt()
    {
        return $this->closed_at;
    }
  
    /**
     * Sets closed_at
     * @param string $closed_at The shift close time in ISO 8601 format.
     * @return $this
     */
    public function setClosedAt($closed_at)
    {
        $this->closed_at = $closed_at;
        return $this;
    }
    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
  
    /**
     * Sets description
     * @param string $description An employee free-text description of a cash drawer shift.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Gets opened_cash_money
     * @return \SquareConnect\Model\Money
     */
    public function getOpenedCashMoney()
    {
        return $this->opened_cash_money;
    }
  
    /**
     * Sets opened_cash_money
     * @param \SquareConnect\Model\Money $opened_cash_money The amount of money in the cash drawer at the start of the shift. This must be a positive amount.
     * @return $this
     */
    public function setOpenedCashMoney($opened_cash_money)
    {
        $this->opened_cash_money = $opened_cash_money;
        return $this;
    }
    /**
     * Gets expected_cash_money
     * @return \SquareConnect\Model\Money
     */
    public function getExpectedCashMoney()
    {
        return $this->expected_cash_money;
    }
  
    /**
     * Sets expected_cash_money
     * @param \SquareConnect\Model\Money $expected_cash_money The amount of money that should be in the cash drawer at the end of the shift, based on the cash drawer events on the shift. The amount is correct if all shift employees accurately recorded their cash drawer shift events. Unrecorded events and events with the wrong amount result in an incorrect expected_cash_money amount that can be negative.
     * @return $this
     */
    public function setExpectedCashMoney($expected_cash_money)
    {
        $this->expected_cash_money = $expected_cash_money;
        return $this;
    }
    /**
     * Gets closed_cash_money
     * @return \SquareConnect\Model\Money
     */
    public function getClosedCashMoney()
    {
        return $this->closed_cash_money;
    }
  
    /**
     * Sets closed_cash_money
     * @param \SquareConnect\Model\Money $closed_cash_money The amount of money found in the cash drawer at the end of the shift by an auditing employee. The amount must be greater than or equal to zero.
     * @return $this
     */
    public function setClosedCashMoney($closed_cash_money)
    {
        $this->closed_cash_money = $closed_cash_money;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
